/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.BlockEvent;
import noppes.npcs.blocks.CustomBlock;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.items.ItemNpcBlock;
import noppes.npcs.util.Util;

public class CustomDoor
extends BlockDoor
implements ITileEntityProvider,
ICustomElement {
    public NBTTagCompound nbtData;
    private EnumBlockRenderType renderType = EnumBlockRenderType.MODEL;

    public CustomDoor(Material material, NBTTagCompound nbtBlock) {
        super(material);
        this.nbtData = nbtBlock;
        String name = "custom_" + nbtBlock.func_74779_i("RegistryName");
        this.setRegistryName("customnpcs", name.toLowerCase());
        this.func_149663_c(name.toLowerCase());
        this.field_149758_A = false;
        this.func_149672_a(CustomBlock.getNbtSoundType(nbtBlock.func_74779_i("SoundType")));
        this.func_149711_c(0.0f);
        this.func_149752_b(10.0f);
        if (nbtBlock.func_150297_b("Hardness", 5)) {
            this.func_149711_c(nbtBlock.func_74760_g("Hardness"));
        }
        if (nbtBlock.func_150297_b("Resistance", 5)) {
            this.func_149752_b(nbtBlock.func_74760_g("Resistance"));
        }
        if (nbtBlock.func_150297_b("LightLevel", 5)) {
            this.func_149715_a(nbtBlock.func_74760_g("LightLevel"));
        }
        if (nbtBlock.func_150297_b("BlockRenderType", 8)) {
            this.renderType = CustomBlock.getNbtRenderType(nbtBlock.func_74779_i("BlockRenderType"));
        }
        this.func_149647_a(CustomRegisters.tabBlocks);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        String name = "";
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockLayer", 8)) {
            name = this.nbtData.func_74779_i("BlockLayer");
        }
        while (name.contains(" ")) {
            name = name.replace(" ", "_");
        }
        switch (name.toLowerCase()) {
            case "cutout": {
                return BlockRenderLayer.CUTOUT;
            }
            case "cutout_mipped": {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }
            case "translucent": {
                return BlockRenderLayer.TRANSLUCENT;
            }
        }
        return BlockRenderLayer.SOLID;
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    @Nonnull
    public ItemStack func_185473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        ItemNpcBlock item = new ItemNpcBlock((Block)this);
        for (Item it : Item.field_150901_e) {
            if (!Objects.requireNonNull(it.getRegistryName()).func_110624_b().equals("customnpcs") || !it.getRegistryName().equals((Object)this.getRegistryName())) continue;
            item = it;
            break;
        }
        return new ItemStack((Item)item, 1, 0);
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        ItemNpcBlock item = new ItemNpcBlock((Block)this);
        for (Item it : Item.field_150901_e) {
            if (!Objects.requireNonNull(it.getRegistryName()).func_110624_b().equals("customnpcs") || !it.getRegistryName().equals((Object)this.getRegistryName())) continue;
            item = it;
            break;
        }
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : item;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return this.renderType;
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabBlocks && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Block)this));
        if (tab == CustomRegisters.tabBlocks) {
            Util.instance.sort(items);
        }
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return this.nbtData != null && this.nbtData.func_74764_b("IsFullCube") && this.nbtData.func_74767_n("IsFullCube");
    }

    public boolean isLadder(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        return this.nbtData.func_74767_n("IsLadder");
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.nbtData != null && this.nbtData.func_74764_b("IsOpaqueCube") && this.nbtData.func_74767_n("IsOpaqueCube");
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        if (this.nbtData != null && this.nbtData.func_74764_b("InteractOpen") && !this.nbtData.func_74767_n("InteractOpen")) {
            return false;
        }
        BlockEvent.DoorToggleEvent event = new BlockEvent.DoorToggleEvent(Objects.requireNonNull(NpcAPI.Instance()).getIBlock(worldIn, pos));
        EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.DOOR_TOGGLE, (Event)event);
        if (event.isCanceled()) {
            return false;
        }
        BlockPos blockpos = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() != this) {
            return false;
        }
        state = iblockstate.func_177231_a((IProperty)field_176519_b);
        worldIn.func_180501_a(blockpos, state, 10);
        worldIn.func_175704_b(blockpos, pos);
        worldIn.func_180498_a(playerIn, ((Boolean)state.func_177229_b((IProperty)field_176519_b)).booleanValue() ? (this.field_149764_J == Material.field_151573_f ? 1005 : 1006) : (this.field_149764_J == Material.field_151573_f ? 1011 : 1012), pos, 0);
        return true;
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockType", 1)) {
            return this.nbtData.func_74771_c("BlockType");
        }
        return 6;
    }
}

